package cn.com.duiba.live.mall.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单的货品关联
 * @author youqian mybatis generator 
 * 2020-04-01
 */
@Data
public class OrderItemDto implements Serializable {
    private static final long serialVersionUID = 15857374892859760L;

    /**
     * 主键ID
     * not null default = null
     */
    private Long id;

    /**
     * 订单项ID
     * not null default = 0
     */
    private Long orderItemId;

    /**
     * 商户ID
     * not null default = 0
     */
    private Long merchantId;

    /**
     * 订单编号
     * not null default = 0
     */
    private Long orderId;

    /**
     * 客户ID
     * not null default = 0
     */
    private Long customerId;

    /**
     * 货号ID
     * not null default = 0
     */
    private Long goodsId;

    /**
     * 货号名称
     * max length = 20
     * not null default = 
     */
    private String goodsName;

    /**
     * 货号规格ID
     * not null default = 0
     */
    private Long skuId;

    /**
     * 商品规格货号
     * max length = 255
     * not null default = 
     */
    private String goodsSpecCode;

    /**
     * 货号规格名称
     * max length = 20
     * not null default = 
     */
    private String skuName;

    /**
     * 货号单价
     * not null default = 0.00
     */
    private BigDecimal price;

    /**
     * 货号商品个数
     * not null default = 0
     */
    private Integer num;

    /**
     * 总价
     * not null default = 0.00
     */
    private BigDecimal totalPrice;

    /**
     * 商品单位
     * max length = 10
     * not null default = 
     */
    private String unit;

    /**
     * 是否删除，0-未删除，其他-已删除
     * not null default = 0
     */
    private Byte deleteFlag;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 商品图片
     */
    private String goodsThumb;

    /**
     * 商品颜色
     */
    private String color;

    /**
     * 款号
     */
    private String shortName;

    /**
     * 商品大小
     */
    private String size;

    /**
     * 订单状态
     */
    private Byte orderStatus;

    /**
     * 库存位
     */
    private Integer placeNum;
}