package cn.com.duiba.live.mall.api.dto.order;

import cn.com.duiba.live.mall.api.dto.PageRequest;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderPageDto extends PageRequest implements Serializable {

    private static final long serialVersionUID = 5570968457893120011L;

    /**
     * 订单状态
     */
    private Byte orderStatus;

    /**
     * 订单状态列表
     */
    private List<Byte> orderStatusList;

    /**
     * 客户ID/等同于customerId
     */
    private Long clientId;

    /**
     * 用户ID
     */
    private Long createUserId;

    /**
     * 商户ID
     */
    private Long merchantId;

    /**
     * 员工ID
     */
    private Long employeeId;

    /**
     * 客户Ids
     */
    private List<Long> customerIds;

    /**
     * 发货状态
     */
    private Byte deliverGoods;

    /**
     * 收款状态
     */
    private List<Byte> moneyReceiveType;
}
