package cn.com.duiba.live.mall.api.dto.shopgoods.custom;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 商品和规格Dto
 * Created by hong
 * time 2020/4/7.
 */
@Data
public class GoodsAndSkuDto implements Serializable {

    private static final long serialVersionUID = -4243319889315878632L;

    private Long id;

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopGoodsId;

    /**
     * 创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     * 更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleteStatus;

    /**
     * 商品类型
     */
    private Integer goodsType;

    /**
     * 显示排序
     */
    private Long displayOrder;

    /**
     * 商品名称
     * max length = 50
     */
    private String goodsName;

    /**
     * 商品短名称
     * max length = 20
     */
    private String shortName;

    /**
     * 商品图oss
     * max length = 100
     */
    private String goodsThumb;

    /**
     * 商品详情
     * max length = 255
     */
    private String goodsContent;

    /**
     * 商品描述
     * max length = 255
     */
    private String goodsDescription;

    /**
     * 商品编号
     * max length = 255
     */
    private String goodsSn;

    /**
     * 商品原价
     */
    private BigDecimal productPrice;

    /**
     * 商品现价
     */
    private BigDecimal marketPrice;

    /**
     * 商品成本
     */
    private BigDecimal costPrice;

    /**
     * 商品库存
     */
    private Integer total;

    /**
     * 显示库存 1显示 0 不显示
     */
    private Byte showTotal;

    /**
     * 减库存方式 0 拍下减库存 1 付款减库存 2 永不减库存
     */
    private Integer totalCnf;

    /**
     * 已售出数
     */
    private Integer sales;

    /**
     * 实际售出数
     */
    private Integer salesReal;

    /**
     * 商户id
     */
    private Long companyId;

    /**
     * 规格数量
     */
    private Integer skuCount;

    /**
     * 颜色种类
     */
    private Integer colorCount;

    /**
     * 尺寸种类
     */
    private Integer sizeCount;

    /**
     * 图片总数
     */
    private Integer goodsPicCount;

    /**
     * 是否选中
     */
    private Boolean selected;
}
