package cn.com.duiba.live.mall.api.enums;

import lombok.Getter;

import java.util.stream.Stream;

/**
 * time 2020/4/9.
 * @author fss
 */
@Getter
public enum FreightTypeEnum {
    TYPE_UNITY(1,"统一运费"),
    TYPE_TEMPLATE(2,"运费模版")
    ;

    private final Integer code;

    private final String type;

    FreightTypeEnum(Integer code, String type) {
        this.code = code;
        this.type = type;
    }

    public static FreightTypeEnum getByCode(Integer code) {
        return Stream.of(FreightTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(TYPE_UNITY);
    }

}

