package cn.com.duiba.live.mall.api.enums.order;

import lombok.Getter;

@Getter
public enum EnumBookingType {

    USER_BOOK((byte) 0, "用户自主申请"),
    EMPLOYEE_BOOK((byte) 1, "员工补录"),
    ;

    EnumBookingType(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumBookingType get(Byte code){
        for(EnumBookingType bookingType:values()){
            if(bookingType.getCode() == code){
                return bookingType;
            }
        }
        return USER_BOOK;
    }

}
