package cn.com.duiba.live.mall.api.enums.order;

import lombok.Getter;

@Getter
public enum EnumGoodsTypes {

    NOT_ORDER((byte) 0, "不用预约"),
    NEED_ORDER((byte) 1, "需要预约"),
    ;

    EnumGoodsTypes(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumGoodsTypes get(Byte code){
        for(EnumGoodsTypes goodsTypes:values()){
            if(goodsTypes.getCode() == code){
                return goodsTypes;
            }
        }
        return NOT_ORDER;
    }

}
