package cn.com.duiba.live.mall.api.enums.order;
import lombok.Getter;

@Getter
public enum EnumRefundStatus {
    REFUND_ZERO((byte) 0, "正常无进行中退款"),
    REFUND_CHECKING((byte) 2, "审核处理中"),
    REFUND_CHECKED((byte) 4, "审核通过"),
    REFUND_PAYING((byte) 6, "退款中"),
    REFUND_PAYFAIL((byte) 7, "退款失败"),
    REFUND_FINISH((byte) 9, "退款完成"),

    ;

    EnumRefundStatus(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumRefundStatus get(Byte code){
        for(EnumRefundStatus refundStatus:values()){
            if(refundStatus.getCode() == code){
                return refundStatus;
            }
        }
        return REFUND_ZERO;
    }
}
