package cn.com.duiba.live.mall.api.enums.order;
import lombok.Getter;

/**
 * @author fss
 */
@Getter
public enum EnumRefundType {
    REFUND_GOODS_MONEY((byte) 0, "退货退款"),
    REFUND_MONEY((byte) 2, "仅退款"),
    REFUND_CHECK((byte) 4, "商家订单审核取消"),

    ;

    EnumRefundType(byte code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final byte code;
    private final String msg;

    public static EnumRefundType get(Byte code) {
        for (EnumRefundType refundStatus : values()) {
            if (refundStatus.getCode() == code) {
                return refundStatus;
            }
        }
        return REFUND_GOODS_MONEY;
    }
}
