package cn.com.duiba.live.mall.api.mq.event;

import lombok.Data;

import java.io.Serializable;

@Data
public class OrderBookingMsgEvent  implements Serializable {

    /**
     * 订单编号
     */
    private String orderNumber;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 订单明细ID
     */
    private Long orderItemId;
    /**
     * 商品名称
     */
    private String goodsName;
    /**
     * Sku名称
     */
    private String skuName;

    /**
     *手机号码
     */
    private String mobile;

    /**
     * 微信使用者ID
     */
    private Long userId;
    /**
     * 使用状态
     */
    private Byte useStatus; //0-预约 1-使用
    /**
     * 商品类型决定 使用状态
     */
    private Byte goodsType; //0-不用预约 1-预约
    /**
     * 消息内容
     */
    private String msg;
    /**
     * 消息通道 0目前默认
     */
    private Integer msgChannel; //0-默认

    /**
     * 预约状态 0-预约成功 1-预约成功等待审核 2-预约审核成功  3-审核有变化
     */
    private Byte bookStatus;

    /**
     * 消息ID
     */
    private String uuid;
}
