package cn.com.duiba.live.mall.api.params.goods;

import cn.com.duiba.live.mall.api.params.shoptag.GoodsTagRelationParam;
import cn.com.duiba.live.mall.api.util.BigDecimalDeserializer;
import cn.com.duiba.live.mall.api.util.BigDecimalSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/22.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AddGoodsParamV2 implements Serializable {

    private static final long            serialVersionUID = -1352958573004338274L;

    /**
     * 商品名
     */
    @NotBlank(message = "商品名不能为空")
    @Size( max= 50,min = 1,message = "商品名应为1-50位")
    private String                       goodsName;

    /**
     * 货号
     */
    @NotBlank(message = "商品编号不能为空")
    @Size( max= 20,min = 1,message = "商品编号应为1-20位")
    private String                       shortName;

    /**
     * 单价
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal marketPrice= BigDecimal.ZERO;

    /**
     * 标签数组
     */
    private List<GoodsTagRelationParam> tags;

    /**
     * 商品图片oss数组
     */
    private List<InsertPicBatchParam> goodsPics;

    /**
     * 规格操作参数数组
     */
    private List<AddSkuParam> skus;

    /**
     * 商品id集合(商品删除用)
     */
    private List<Long>                   goodsIds;

    /**
     * 商户ID
     */
    private Long companyId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 商品类型 0-服装  1-门票 2-酒店 3-消费券
     */
    private Integer goodsType=1;

    /**
     * 富文本说明介绍
     * not null default = null
     */
    private String goodsIntroduction;

    /**
     * 销售状态
     */
    private Byte saleStatus;

    /**
     * 商品详情
     * 用于显示商品 短名称
     */
    private String goodsContent;

    /**
     * 商品描述
     * 用于显示 景点地址JSON
     */
    private String goodsDescription;

    /**
     * 商品编号
     * 用于显示 商品标签
     */
    private String goodsSn;

    /**
     *购买按钮文案
     */
    private String buyButtonText;

    /**
     *是否需要审核
     */
    private Byte needReview;

    /**
     *运费类型 1统一运费  2运费模板
     */
    private Byte freightType;

    /**
     *统一运费价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal freightAmount;

    /**
     *代发货文案
     */
    private String waitShipText;

    /**
     *商品标签
     */
    private String goodsTags;
}
