package cn.com.duiba.live.mall.api.params.goods;

import cn.com.duiba.live.mall.api.params.goods.spec.AddSkuSpecParamV1;
import cn.com.duiba.live.mall.api.util.BigDecimalDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/22.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AddSkuParam implements Serializable {

    private static final long serialVersionUID = -212636563529206686L;

    /**
     * 库存
     */
    private Integer stockQuantity;

    /**
     * 名称
     * max length = 100
     */
    private String skuName;

    /**
     * 商品规格码
     * max length = 255
     */
    private String goodsSpecCode;

    /**
     * 价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal price=BigDecimal.ZERO;

    /**
     * 是否选中
     */
    private Boolean selected;

    /**
     * 规格集合
     */
    private List<AddSkuSpecParamV1> specs=new ArrayList<>();

    /**
     * 销售价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal salePrice;

    /**
     * 市场价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal marketPrice;



}
