package cn.com.duiba.live.mall.api.params.goods;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class GoodsIntroductionParam  implements Serializable {

    private static final long serialVersionUID = 1423308188732313890L;

    /**
     * 商户ID
     */
    private Long companyId;


    /**
     * 商品ID 不可为空
     */
    private Long shopGoodsId;

    /**
     * 商品SKUID 可为空
     */
    private Long shopGoodsSkuId;

    /**
     * 详细介绍
     */
    @NotBlank(message = "商品介绍不能为空")
    private String introduction;
}
