package cn.com.duiba.live.mall.api.params.goods;

import cn.com.duiba.live.mall.api.params.shoptag.GoodsTagRelationParam;
import cn.com.duiba.live.mall.api.util.BigDecimalDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/23.
 */
@Data
public class UpdateGoodsParam implements Serializable {

    private static final long serialVersionUID = 1640547978088990764L;

    /**
     * 商品id
     */
    private Long shopGoodsId;

    /**
     * 商品名
     */
    @NotBlank(message = "商品名不能为空")
    @Size(max = 50, min = 1, message = "商品名应为1-50位")
    private String goodsName;

    /**
     * 货号
     */
    @NotBlank(message = "货号不能为空")
    @Size(max = 20, min = 1, message = "货号应为1-20位")
    private String shortName;

    /**
     * 单价
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal marketPrice=BigDecimal.ZERO;


    /**
     * 标签数组
     */
    private List<GoodsTagRelationParam> tags;

    /**
     * 商品图片oss数组
     */
    private List<InsertPicBatchParam> goodsPics;

    /**
     * 规格操作参数数组
     */
    private List<UpdateSkuParam> skus;

    /**
     * 商户ID
     */
    private Long companyId;

    /**
     * 富文com介绍
     * not null default = null
     */
    private String goodsIntroduction;

    private Integer goodsType=1;

    /**
     * 销售状态
     */
    private byte saleStatus;

    /**
     * 商品详情
     * 用于显示商品 短名称
     */
    private String goodsContent;

    /**
     * 商品描述
     * 用于显示 景点地址JSON
     */
    private String goodsDescription;

    /**
     * 商品编号
     * 用于显示 商品标签
     */
    private String goodsSn;

    /**
     *兑换按钮文案
     */
    private String redeemButtonText;

    /**
     *是否需要审核
     */
    private Byte needReview;

    /**
     *运费类型 1统一运费  2运费模板
     */
    private Byte freightType;

    /**
     *统一运费价格
     */
    private BigDecimal freightAmount;

    /**
     *代发货文案
     */
    private String waitShipText;

    /**
     * 缩略图
     */
    private String goodsThumb;

    /**
     *商品标签
     */
    private String goodsTags;
}
