package cn.com.duiba.live.mall.api.params.goods;

import cn.com.duiba.live.mall.api.params.goods.spec.UpdateSkuSpecParam;
import cn.com.duiba.live.mall.api.util.BigDecimalDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by hong
 * time 2020/10/23.
 */
@Data
public class UpdateSkuParam implements Serializable {


    private static final long serialVersionUID = -8287799626840646588L;

    /**
     * skuId
     * not null default = null
     */
    private Long shopGoodsSkuId;

    /**
     * 库存
     */
    private Integer stockQuantity;

    /**
     * 名称
     * max length = 100
     */
    private String skuName;

    /**
     * 商品规格码
     * max length = 255
     */
    private String goodsSpecCode;

    /**
     * 价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal price=BigDecimal.ZERO;

    /**
     * 是否选中
     */
    private Boolean selected;

    /**
     * 规格集合
     */
    private List<UpdateSkuSpecParam> specs=new ArrayList<>();

    /**
     * 是否被修改
     */
    private Boolean modified;

    /**
     * 是否删除，1=已删除，0=未删除
     * not null default = 0
     */
    private Byte deleteStatus=(byte)0;

    /**
     * 销售价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal salePrice;

    /**
     * 市场价格
     */
    @JsonDeserialize(using = BigDecimalDeserializer.class)
    private BigDecimal marketPrice;


}
