package cn.com.duiba.live.mall.api.params.goods.spec;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Created by hong
 * time 2020/10/22.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AddSkuSpecParamV1 implements Serializable {

    private static final long serialVersionUID = 3593257154293196050L;

    /**
     * 规格键
     */
    private String key;

    /**
     * 规格键id
     */
    private Long keyId;

    /**
     * 规格值
     */
    private String value;

    /**
     * 规格值id
     */
    private Long valueId;

    /**
     * 是否必选  1必选
     * not null default = 0
     */
    private Byte whetherRequired;

    /**
     * 是否多选 1多选
     * not null default = 0
     */
    private Byte whetherMulti;

    /**
     * 是否颜色属性  1是
     * not null default = 0
     */
    private Byte whetherColor;

    /**
     * 是否枚举属性  1是
     * not null default = 0
     */
    private Byte whetherEnumeration;

    /**
     * 是否填写属性  1是
     * not null default = 0
     */
    private Byte whetherInput;

    /**
     * 是否关键属性  1是
     ps：
     能够确认唯一"产品"的属性，可以是一个，或者多个关键属性的组合。如：手机的"品牌""型号"能确定唯一的产品，服装的"品牌""货号"能确定唯一的产品
     * not null default = 0
     */
    private Byte whetherCrux;

    /**
     * 是否销售属性  1是
     ps：
     组成SKU的特殊属性，它会影响买家的购买和卖家的库存管理，如服装的"颜色"、"套餐"和"尺码"

     * not null default = 0
     */
    private Byte whetherSale;

    /**
     * 服装商场的特殊需求，只要颜色和尺寸
     1代表颜色属性
     2代表尺寸属性
     0代表其他属性
     * not null default = 0
     */
    private Byte colorOrSize;
}
