package cn.com.duiba.live.mall.api.params.order;

import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class OrderCommissionParam implements Serializable {

    /**
     * 查看佣金类型
     * 0-所有佣金订单  1-有待结算的订单  2-已结算的订单
     */
    @NotNull(message = "查看佣金类型不能为空")
    @Min(value = 0, message = "查看佣金类型 0-所有佣金订单  1-有待结算的订单  2-已结算的订单")
    private Byte type;

    /**
     * 用户编号
     */
    private Long userId;

    /**
     * 商户编号
     */
    private Long merchantId;

}
