package cn.com.duiba.live.mall.api.remoteservice.express;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.mall.api.dto.express.ExpressTemplateOptionDto;

import java.util.List;

/**
 *
 * 加钱购商品运费模版选项service
 */
@AdvancedFeignClient
public interface RemoteExpressTemplateOptionService {

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	ExpressTemplateOptionDto find(Long id);

	/**
	 * 新增记录
	 * 
	 * @param entity
	 * @return
	 */
	Long insert(ExpressTemplateOptionDto entity);

	/**
	 * 更新记录
	 * 
	 * @param entity
	 */
	Integer update(ExpressTemplateOptionDto entity);

	/**
	 * 根据模版ID查询
	 * 
	 * @param expressTemplateId
	 * @return
	 */
	List<ExpressTemplateOptionDto> findByTemplateId(Long expressTemplateId);

	/**
	 * 根据模版ID集合批量查询
	 * 
	 * @param ids
	 * @return
	 */
	List<ExpressTemplateOptionDto> findByTemplateIds(List<Long> ids);

	/**
	 * 根据模版ID删除
	 * 
	 * @param expressTemplateId
	 * @return
	 */
	Integer deleteOptionByTemplateId(Long expressTemplateId);

	/**
	 * 添加模版选项
	 * 
	 * @param ambExpressTemplateOptionDOs
	 * @return
	 */
	Integer batchInsert(List<ExpressTemplateOptionDto> ambExpressTemplateOptionDOs);

}
