package cn.com.duiba.live.mall.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.mall.api.dto.order.SendDto;
import cn.com.duiba.live.mall.api.request.OrderBatchSendRequest;
import cn.com.duiba.live.mall.api.request.OrderCheckRequest;
import cn.com.duiba.live.mall.api.request.OrderSearchRequestV5;
import cn.com.duiba.live.mall.api.request.OrderSendRequest;
import cn.com.duiba.live.mall.api.response.OrderPageResult;
import cn.com.duiba.live.mall.api.response.base.PageResult;

import java.util.List;

/**
 * @Author: fss
 * @Date: 2021/8/10 20
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteOrderService {

    /**
     * 处理下单后  未付款的旅游订单
     */
    void doExpired();

    /**
     * 卖家订单列表
     * @param orderSearchRequest 搜索条件
     * @return
     */
    PageResult<OrderPageResult> orderPageV5(OrderSearchRequestV5 orderSearchRequest);

    /**
     * 卖家订单审核
     * @param request 订单ID
     * @return
     */
    Boolean check(OrderCheckRequest request);

    /**
     * 卖家订单发货
     * @param request
     * @return
     */
    Boolean deliver(OrderSendRequest request);

    /**
     * 批量发货
     * @param request
     * @return
     */
    List<OrderPageResult> findWaitSendByOrderNums(OrderBatchSendRequest request);

    /**
     *
     * 批量发货
     * @param ordersDtos
     * @return
     */
    int batchExecuteObjectSend(List<SendDto> ordersDtos);
}
