package cn.com.duiba.live.mall.api.request;

import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author fss
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode()
public class CreateOrderRequestV5 implements Serializable {

    /**
     * 直播间编号
     */
    private Long liveRoomId;

    /**
     * 商品ID
     */
    @NotNull(message = "商品ID不能为空")
    @Min(value = 1, message = "商品ID必须大于0")
    private Long shopGoodsId;

    /**
     * 商品详情
     */
    @Valid
    @NotNull
    @Size(min = 1)
    private List<CreateOrderItemRequestV5> skuList;

    /**
     * 用户ID
     */
    private Long liveUserId;

    private String ip;
//    /**
//     * 商品名称
//     */
//    @NotBlank(message = "商品名称不能为空")
//    private String goodsName;
//
//    /**
//     * 商品类型  是否需要预约
//     */
//    @NotNull(message = "商品类型不能为空")
//    @Min(value = 0, message = "商品类型必须大于0")
//    private Byte goodsType;
//
//
//    /**
//     * 商品图片
//     */
//    private String goodsThumb;
//    /**
//     * 分享人员工编号
//     */
//    private Long shareUserId;
//    /**
//     * 分享员工名称
//     */
//    private String shareUserName;

    public static void main(String[] args) {
        CreateOrderRequestV5 createOrderRequestV5 = new CreateOrderRequestV5();
        createOrderRequestV5.setShopGoodsId(1L);
        createOrderRequestV5.setLiveRoomId(1L);
        CreateOrderItemRequestV5 createOrderItemRequestV5 = new CreateOrderItemRequestV5();
        createOrderItemRequestV5.setSkuId(1L);
        createOrderItemRequestV5.setNum(1);
        createOrderRequestV5.setSkuList(Collections.singletonList(createOrderItemRequestV5));
        System.err.println(JSON.toJSONString(createOrderRequestV5));
    }
}
