package cn.com.duiba.live.mall.api.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 商品运费
 *
 * @author fss
 */
@Data
@EqualsAndHashCode()
public class OrderTransportFeeRequest implements Serializable {

    /**
     * 商品ID
     */
    @NotNull(message = "商品ID不能为空")
    @Min(value = 1, message = "商品ID必须大于0")
    private Long shopGoodsId;

    /**
     * 商品型号ID
     */
    @NotNull(message = "商品型号ID不能为空")
    @Min(value = 1, message = "商品型号ID必须大于0")
    private Long skuId;

}
