package cn.com.duiba.live.mall.api.util;

import com.caucho.hessian.io.AbstractStringValueDeserializer;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * @author tengtuox
 * @date 2020/9/24
 * @description
 */
public class LocalDateDeserializer extends AbstractStringValueDeserializer {

    @Override
    public Class<?> getType() {
        return LocalDate.class;
    }

    @Override
    protected Object create(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }

        return LocalDate.parse(value, DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

}
