/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.mall.api.dto;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class PageDto<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -8232521877212346922L;
    private List<T> list = Collections.emptyList();
    private int pageNo = 1;
    private int pageSize = 10;
    private int totalPages = 1;
    private int totalSize = 0;
    private Boolean hasNext = false;

    public static <T extends Serializable> PageDto<T> create(List<T> list, int pageNo, int pageSize, int totalSize) {
        PageDto<T> pageDto = new PageDto<T>();
        pageDto.setList(list);
        pageDto.setPageNo(pageNo);
        pageDto.setPageSize(pageSize);
        pageDto.setTotalSize(totalSize);
        pageDto.setHasNext(list.size() == pageSize && pageNo * pageSize != totalSize);
        int totalPage = totalSize % pageSize == 0 ? totalSize / pageSize : totalSize / pageSize + 1;
        pageDto.setTotalPages(totalPage);
        return pageDto;
    }

    public List<T> getList() {
        return this.list;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public Boolean getHasNext() {
        return this.hasNext;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public void setHasNext(Boolean hasNext) {
        this.hasNext = hasNext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageDto)) {
            return false;
        }
        PageDto other = (PageDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$list = this.getList();
        List<T> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        if (this.getTotalSize() != other.getTotalSize()) {
            return false;
        }
        Boolean this$hasNext = this.getHasNext();
        Boolean other$hasNext = other.getHasNext();
        return !(this$hasNext == null ? other$hasNext != null : !((Object)this$hasNext).equals(other$hasNext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        result = result * 59 + this.getPageNo();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getTotalPages();
        result = result * 59 + this.getTotalSize();
        Boolean $hasNext = this.getHasNext();
        result = result * 59 + ($hasNext == null ? 43 : ((Object)$hasNext).hashCode());
        return result;
    }

    public String toString() {
        return "PageDto(list=" + this.getList() + ", pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ", totalPages=" + this.getTotalPages() + ", totalSize=" + this.getTotalSize() + ", hasNext=" + this.getHasNext() + ")";
    }
}

