/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.mall.api.response;

import cn.com.duiba.live.mall.api.exception.ErrorCode;
import cn.com.duiba.live.mall.api.response.Result;
import org.apache.commons.lang3.StringUtils;

public final class ResultBuilders {
    private static final String DEFAULT_SUCCESS_CODE = "000000";
    private static final String DEFAULT_FAIL_CODE = "999999";

    private ResultBuilders() {
    }

    public static <T> Result<T> fail(String code, String desc) {
        Result result = new Result();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(StringUtils.isBlank((CharSequence)code) ? DEFAULT_FAIL_CODE : code);
        result.setDesc(desc);
        return result;
    }

    public static <T> Result<T> fail(String desc) {
        return ResultBuilders.fail(DEFAULT_FAIL_CODE, desc);
    }

    public static <T> Result<T> bizFail(String code, String desc) {
        return ResultBuilders.fail(code, desc);
    }

    public static <T> Result<T> fail(ErrorCode errCode) {
        return ResultBuilders.fail(errCode.getCode().toString(), errCode.getDesc());
    }

    public static <T> Result<T> fail(ErrorCode errCode, T data) {
        Result<T> result = new Result<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(errCode.getCode().toString());
        result.setDesc(errCode.getDesc());
        result.setData(data);
        return result;
    }

    public static <T> Result<T> fail(String desc, T data) {
        return ResultBuilders.fail(DEFAULT_FAIL_CODE, desc, data);
    }

    public static <T> Result<T> fail(String code, String desc, T data) {
        Result<T> result = new Result<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> success(String code, T data) {
        Result<T> result = new Result<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(true);
        result.setCode(code);
        result.setData(data);
        result.setDesc("OK");
        return result;
    }

    public static <T> Result<T> success(T data) {
        return ResultBuilders.success(DEFAULT_SUCCESS_CODE, data);
    }

    public static <T> Result<T> success() {
        return ResultBuilders.success(DEFAULT_SUCCESS_CODE, null);
    }
}

