package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @date:2022/1/7 17:27
 * @author:zhaozhanghai
 * @Description: 供应商app定向服务
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierDirectionalAppService {
    /**
     * pop商户appId定向
     * @param supplierId
     * @param appIds
     * @return 上一次定向的appIds
     */
    String directional(Long supplierId,String appIds) throws BizException;


    /**
     * 筛选出开启app定向的supplierId
     * @param supplierIds
     * @return supplierIds 返回开启定向的supplierId
     */
    List<Long> countSupplierExistAppId( List<Long> supplierIds);

    /**
     * 获取supplierId开启定向的appIds
     * @param supplierId
     * @return appIds
     */
    List<Long> listAppIdsBySupplierId(Long supplierId);



}
