package cn.com.duiba.supplier.center.api.enums.supplier;

/**
 * @date:2022/1/7 15:27
 * @author:zhaozhanghai
 * @Description: 供应商类型
 */
public enum DuibaLiveSupplierTypeEnum {
    self(0,"自营"),
    pop(1,"pop");

    DuibaLiveSupplierTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private Integer type;
    private String desc;
    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static DuibaLiveSupplierTypeEnum fromValue(int type) {
        for (DuibaLiveSupplierTypeEnum it : DuibaLiveSupplierTypeEnum.values()) {
            if (type == it.getType()) {
                return it;
            }
        }
        return null;
    }
}
