package cn.com.duiba.supplier.center.api.params;

import cn.com.duiba.supplier.center.api.base.BasePage;

import java.io.Serializable;
import java.util.List;

/**
 * @date:2022/1/7 11:42
 * @author:zhaozhanghai
 * @Description:
 */
public class DuibaLiveSupplierOrderPageParam extends BasePage implements Serializable {
    private static final long serialVersionUID = -6917733927527253841L;
    /**
     * 订单号
     */
    private String orderNum;
    /**
     * 商品备注
     */
    private String itemDesc;
    /**
     * 下单开始时间 yyyy-MM-dd
     */
    private String startTime;
    /**
     * 下单结束时间 yyyy-MM-dd
     */
    private String endTime;
    /**
     * 供应商类型 0-自营 1-pop
     */
    private String supplierType;
    /**
     * 订单状态
     * none
     * wait_pay
     * pay_success
     * pay_back
     * canceled
     * success
     */
    private String status;
    /**
     * 关联订单的类型
     * 0=普通订单
     * 1=专题活动订单
     * 2=单品抽奖
     * 3=大转盘订单
     * 4=手动开奖
     * 5=活动工具
     * 6=游戏活动
     * 7=秒杀专题
     * 8=答题活动
     * 10=测试题活动
     * 9=秒杀活动
     * 11=新游戏
     * 12=竞猜活动
     * 13=今日必抢
     * 14=积分游戏
     * 15=小游戏
     * 16=插件活动
     * 17=弹层活动
     * 18=签到活动
     */
    private String relationType;
    /**
     * 商品名
     */
    private String itemName;

    /**
     * 商品备注
     */
    private String itemRemark;
    /**
     * 商品类型
     */
    private String itemType;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 订单状态值
     *   PROCESSING(-1,"处理中"),
     *     WAIT_PAY(100,"等待买家付款"),
     *     WAIT_AUDIT(200,"待商家审核"),
     *     WAIT_SEND(300,"等待卖家发货"),
     *     WAIT_RECEIVE(400,"卖家已发货"),
     *     RECEIVE(500,"已收货"),
     *     POST_SALE(600,"售后"),
     *     TIME_OUT(700,"已失效"),
     *     CANCEL(800,"已取消"),
     *     SUCCESS(900,"已完成"),
     *     ERROR(1000,"异常"),
     *     //兼容老数据用
     *     FAIL(1100,"失败"),
     */
    private Integer statusInt;


    /**
     * 兑吧商品ids
     */
    private List<Long> duibaItemIds;

    private List<String> notInRelationType;

    public DuibaLiveSupplierOrderPageParam() {
        super.setPageSize(20L);
        super.setPageNo(1L);
    }

    public List<String> getNotInRelationType() {
        return notInRelationType;
    }

    public void setNotInRelationType(List<String> notInRelationType) {
        this.notInRelationType = notInRelationType;
    }

    public String getItemRemark() {
        return itemRemark;
    }

    public void setItemRemark(String itemRemark) {
        this.itemRemark = itemRemark;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getItemDesc() {
        return itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getSupplierType() {
        return supplierType;
    }

    public void setSupplierType(String supplierType) {
        this.supplierType = supplierType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }



    public List<Long> getDuibaItemIds() {
        return duibaItemIds;
    }

    public void setDuibaItemIds(List<Long> duibaItemIds) {
        this.duibaItemIds = duibaItemIds;
    }

    public Integer getStatusInt() {
        return statusInt;
    }

    public void setStatusInt(Integer statusInt) {
        this.statusInt = statusInt;
    }
}
