package cn.com.duiba.supplier.center.api.remoteservice.goods.desc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.goods.desc.GoodsDescConfigDto;

/**
 * @Desc 商品图文描述后台管理service
 * @Author xuwei
 * @Date 2018/11/6
 */
@AdvancedFeignClient
public interface RemoteGoodsDescConfigService {

    /**
     * 根据Id查询商品图文描述
     *
     * @param goodsId 供应商商品id
     * @return 商品图文描述
     */
    GoodsDescConfigDto findByGoodsId(Long goodsId);

    /**
     * 更新
     *
     * @param descConfig 商品图文描述
     * @return 更新结果
     */
    int update(GoodsDescConfigDto descConfig);

    /**
     * 新增
     *
     * @param descConfig 商品图文描述
     * @return 描述Id
     */
    int insert(GoodsDescConfigDto descConfig);

}
