package cn.com.duiba.supplier.center.api.remoteservice;

import cn.com.duiba.api.bo.reqresult.Result;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.*;

import java.util.Map;

/**
 * @date:2022/1/7 11:38
 * @author:zhaozhanghai
 * @Description: 供应商 宝付通账户信息
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveSupplierBftService {


    DuibaLiveSupplierBftDto getById(Long id);

    /**
     * 供应商id 获取 bft账户信息
     * @param supplierId
     * @return
     */
    DuibaLiveSupplierBftDto getBySupplierId(Long supplierId);

    Long save(DuibaLiveSupplierBftDto duibaLiveSupplierBftDto);

    int updateById(DuibaLiveSupplierBftDto duibaLiveSupplierBftDto);

    /**
     * 宝付通开户
     * @param duibaLiveSupplierBftDto
     * @return
     */
    Result<Boolean> openBft(DuibaLiveSupplierBftDto duibaLiveSupplierBftDto) throws Exception;


    /**
     * 宝付开户通知
     *
     * @param RDateArry 请求参数
     * @return
     */
    Boolean openAccountNotify(Map<String, String> RDateArry);





}
