package cn.com.duiba.live.supplier.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @date:2022/1/7 11:40
 * @author:zhaozhanghai
 * @Description:
 */
@Data
public class DuibaLiveSupplierBftDto implements Serializable {


    private static final long serialVersionUID = -5916547101080114542L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 登陆账号-supplierId 用户登录注册号，为用户在商户下唯一编号
     */
    private Long loginNo;

    /**
     * 邮箱 用于接收注册邮箱
     */
    private String email;

    /**
     * 法人是否实际控制 0-否 1-是
     */
    private String inControl;

    /**
     * 受益人是否实际控制人 0-否 1-是
     */
    private String inBenefit;

    /**
     * 填写人是否法人 0-否 1-是
     */
    private String proposer;

    /**
     * 企业名称
     */
    private String merchantName;

    /**
     * 企业地址
     */
    private String merchantAddress;

    /**
     * 社会信用代码
     */
    private String regNo;

    /**
     * 注册资本 元
     */
    private String regCapital;

    /**
     * 法人姓名
     */
    private String corporateName;

    /**
     * 法人身份证号
     */
    private String corporateIdCard;

    /**
     * 联系人手机号
     */
    private String contactMobile;

    /**
     * 开户名称
     */
    private String cardName;

    /**
     * 开户银行
     */
    private String bankName;

    /**
     * 开户所在省
     */
    private String provinceName;

    /**
     * 开户所在市
     */
    private String cityName;

    /**
     * 开户银行支行名称
     */
    private String branchName;

    /**
     * 企业对公账号
     */
    private String cardNo;

    /**
     * 经营范围
     */
    private String businessScope;

    /**
     * 代理人姓名 proposer为0时填写
     */
    private String agentName;

    /**
     * 代理人身份证号 proposer为0时填写
     */
    private String agentIdCard;

    /**
     * 受益人类型 inBenefit为0时填写;0-个人 1-企业
     */
    private Integer beneficiaryType;

    /**
     * 受益人归属地 beneficiaryType为0时填写
     */
    private String beneficiaryArea;

    /**
     * 受益人姓名 beneficiaryType为0时填写
     */
    private String beneficiaryName;

    /**
     * 受益人身份证号 beneficiaryType为0时填写
     */
    private String beneficiaryIdCard;

    /**
     * 受益人身份证是否长期    beneficiaryType为0时填写；0-否 1-是
     */
    private Integer beneficiaryIdCardExtended;

    /**
     * beneficiaryType为0时填写，格式：yyyy-MM-hh;如果受益人身份证有效期限为长期，请设置为2099-12-31
     */
    private Date beneficiaryIdCardExpireDate;

    /**
     * 受益人企业名称 beneficiaryType为1时填写
     */
    private String beneficiaryCompanyName;

    /**
     * 受益人社会信用代码(注册号) beneficiaryType为1时填写
     */
    private String beneficiaryRegNo;

    /**
     * 受益人营业期限是否长期   beneficiaryType为1时填写；0-否 1-是
     */
    private Integer beneficiaryBusinessExtended;

    /**
     * 受益人营业有效期限 beneficiaryType为1时填写，格式：yyyy-MM-hh;如果受益人营业有效期限为长期，请设置为2099-12-31
     */
    private Date beneficiaryBusinessExpireDate;

    /**
     * 实际控制人类型 inControl为0时填写;0-个人 1-企业
     */
    private Integer controllerType;

    /**
     * 实际控制人归属地  controllerType为0时填写
     */
    private String controllerArea;

    /**
     * 实际控制人姓名 controllerType为0时填写
     */
    private String controllerName;

    /**
     * 实际控制人身份证号 controllerType为0时填写
     */
    private String controllerIdCard;

    /**
     * 实际控制人身份证是否长期 controllerType为0时填写；0-否 1-是
     */
    private Integer controllerIdCardExtended;

    /**
     * 实际控制人身份证有效期限 controllerType为0时填写，格式：yyyy-MM-hh;如果实际控制人身份证有效期限为长期，请设置为2099-12-31
     */
    private Date controllerIdCardExpireDate;

    /**
     * 实际控制人企业名称 controllerType为1时填写
     */
    private String controllerCompanyName;

    /**
     * 实际控制人社会信用代码(注册号) controllerType为1时填写
     */
    private String controllerRegNo;

    /**
     * 实际控制人营业期限是否长期 controllerType为1时填写；0-否 1-是
     */
    private Integer controllerBusinessExtended;

    /**
     * 实际控制人营业有效期限 controllerType为1时填写，格式：yyyy-MM-hh;如果实际控制人营业有效期限为长期，请设置为2099-12-31
     */
    private Date controllerBusinessExpireDate;

    /**
     * 营业执照图片
     */
    private String base64ImgForLicense;

    /**
     * 法人身份证头像图片
     */
    private String base64ImgFrontForCorporate;

    /**
     * 法人身份证国徽图片
     */
    private String base64ImgBackForCorporate;

    /**
     * 代理人身份证头像图片 申请开户时proposer为0时，必填。代理人申请开户时上传
     */
    private String base64ImgFrontForAgent;

    /**
     * 代理人身份证国徽图片 申请开户时proposer为0时，必填。代理人申请开户时上传
     */
    private String base64ImgBackForAgent;

    /**
     * 代理人委托书 代理人申请开户时上传
     */
    private String base64ImgForAgentPaper;

    /**
     * 宝付通商户号
     */
    private String merchantCode;

    /**
     * 宝付通终端号
     */
    private String terminalCode;

    /**
     * 宝付通跨境商户号
     */
    private String merchatCrossCode;

    /**
     * 宝付通跨境终端号
     */
    private String terminalCrossCode;

    /**
     * 开户状态 0-无状态 1-提交开户申请 2-开户申请成功 3-开户申请失败 4-上传资料成功 5-开户成功
     */
    private Integer openStatus;

    /**
     * 客户账户号
     */
    private String contractNo;

    /**
     * 客户名
     */
    private String customerName;

    /**
     * 客户绑定手机
     */
    private String mobile;
}
