package cn.com.duiba.live.supplier.center.api.params;

import cn.com.duiba.live.supplier.center.api.base.BasePage;

import java.io.Serializable;
import java.util.List;

/**
 * @date:2022/1/10 15:23
 * @author:zhaozhanghai
 * @Description: 售后订单列表 查询参数
 */
public class DuibaLiveSupplierPostsaleOrderPageParam extends BasePage implements Serializable {
    private static final long serialVersionUID = -1242613084613300129L;
    /**
     *  订单号
     */
    private  String orderNum;

    /**
     * appId
     */
    private Long appId;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    /**
     * 兑换项
     */
    private String itemName;

    /**
     * 售后状态:
     wait:待售后,
     refunding:退款中,
     reject:拒绝售后,
     canceled:取消售后,
     agree:同意售后 处理中,
     success:售后成功
     */
    private String postsaleStatus;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 兑吧商品ids
     */
    private List<Long> duibaItemIds;

    public DuibaLiveSupplierPostsaleOrderPageParam() {
        super.setPageSize(20L);
        super.setPageNo(1L);
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getPostsaleStatus() {
        return postsaleStatus;
    }

    public void setPostsaleStatus(String postsaleStatus) {
        this.postsaleStatus = postsaleStatus;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public List<Long> getDuibaItemIds() {
        return duibaItemIds;
    }

    public void setDuibaItemIds(List<Long> duibaItemIds) {
        this.duibaItemIds = duibaItemIds;
    }


}
