package cn.com.duiba.live.supplier.center.api.dto;

import cn.com.duiba.live.supplier.center.api.dto.goods.desc.GoodsDescConfigSimpleDto;
import cn.com.duiba.live.supplier.center.api.dto.goods.price.DuibaLiveSupplierGoodsPriceDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 供应商商品库
 *
 * @author fss
 */
@Data
public class DuibaLiveSupplierGoodsDto implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 实际价格
     */
    private Integer actualPrice;

    /**
     * 商品描述
     */
    private String description;

    /**
     * 备注
     */
    private String memo;

    /**
     * 是否启用
     */
    private Integer enable;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 图片
     */
    private String image;

    /**
     * lOGO
     */
    private String logo;

    /**
     * 分享图
     */
    private String shareImage;

    /**
     * 名称
     */
    private String name;

    /**
     * 排序
     */
    private Integer payload;

    /**
     * 子标题
     */
    private String subtitle;

    /**
     * 标签
     */
    private String tag;

    /**
     * 类型
     */
    private String type;

    /**
     * 自定义价格
     */
    private String customPrice;

    /**
     * 小图
     */
    private String smallImage;

    /**
     * 限制次数
     */
    private Integer limitCount;

    /**
     * 限制类型
     */
    private String limitScope;

    /**
     * 多图
     */
    private String multiImage;

    /**
     * App专属商品
     */
    private Long ownerAppId;

    /**
     * 销售数量
     */
    private Integer sales;

    /**
     * 提示消息
     */
    private String alertMessage;

    /**
     * 是否删除
     */
    private Boolean deleted;

    /**
     * 商品费率
     */
    private String productPrice;

    /**
     * 发布时间
     */
    private Date publishTime;

    /**
     * 是否展示警示区
     */
    private Boolean showAlert;

    /**
     * Int类型
     */
    private Integer typeInt;

    /**
     * Banner图片
     */
    private String bannerImage;

    /**
     * 商品类型 移位运算 第0位：限时商品 第1位：限量商品 第2位：是否运营商品 等
     */
    private Integer operationsType;

    /**
     * 分类ID
     */
    private Long itemClassifyId;

    /**
     * 来源ID
     */
    private Long sourceRelationId;

    /**
     * 来源类型
     */
    private Integer sourceType;

    /**
     * 市场价
     */
    private Integer marketPrice;

    /**
     *
     */
    private String json;

    /**
     *
     */
    private String whiteImage;

    /**
     * 兑换价格
     */
    private Long salePrice;

    /**
     * 运费类型 free包邮,unify统一运费,template运费模板
     */
    private String expressType;

    /**
     * 运费价格
     */
    private Long expressPrice;

    /**
     * 库存预警值
     */
    private Integer stockWarnValue;

    /**
     * 商家ID
     */
    private Long sellerId;

    /**
     * 是否多规格
     * {@link cn.com.duiba.live.supplier.center.api.enums.common.BooleanEnum}
     */
    private Integer multiSku;

    /**
     * 供应商ID
     */
    private Long distributorId;

    /**
     * 商家编码
     */
    private String merchantCoding;

    /**
     * 优惠券类型，目前只给优惠券使用 0-普通类型 1-链接类型 2--可重复类型
     */
    private Integer subType;

    /**
     * 兑吧商品ID
     */
    private Long duibaItemId;

    /**
     * 卡券ID
     */
    private Long cardLibraryId;

    /**
     * 是否包含跨境商品 0-不包含 1-包含
     */
    private Integer isCross;

    /**
     * 剩余
     */
    private Integer remaining;

    /**
     * 商品价格区间
     */
    private DuibaLiveSupplierGoodsPriceDto goodsPrice;

    /**
     * 商品图文描述
     */
    private GoodsDescConfigSimpleDto goodsDescConfig;

    /**
     * 商品sku规格属性
     */
    private List<DuibaLiveSupplierGoodsSkuDto> goodsSkuList;

}

