package cn.com.duiba.live.supplier.center.api.dto.goods.sync;

import cn.com.duiba.live.supplier.center.api.enums.goods.DuibaLiveGoodsCouponType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author zhuenhui
 * @date 2022/01/11 19:36
 * @description 商品 - 卡券详情Dto
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SupplierGoodsCouponDto extends SupplierGoodsBaseDto {

    private static final long serialVersionUID = -3522140788431859954L;

    // ------- 通用  -------

    /**
     * 卡券类型
     * 0-普通优惠券 1-链接类型优惠券 2-可重复优惠券 3-卡密
     * {@link DuibaLiveGoodsCouponType}
     */
    private Integer subType;

    /**
     * 卡券库id (普通券码、卡密使用)
     */
    private Long cardLibraryId;

    /**
     * 是否开启按钮
     */
    private Integer showButton;

    /**
     * 跳转链接
     */
    private String linkUrl;

    /**
     * 按钮自定义文案
     */
    private String jumpButtonText;

    // ------- 普通券码  -------

    /**
     * 是否显示条形码
     */
    private Integer showBarCode;

    // ------- 跳转链接、可重复使用券码  -------

    /**
     * 券码
     */
    private String couponCode;

}
