package cn.com.duiba.live.supplier.center.api.enums.supplier;

/**
 * @Author: fss
 * @Date: 2022/1/8 10
 * @Description:跨境商品枚举
 */
public enum DuibaLiveSupplierGoodsCrossEnums {
    NORMAL_GOODS(0, false, "非跨境商品"),
    CROSS_GOODS(1, true, "跨境商品"),
    ;

    DuibaLiveSupplierGoodsCrossEnums(Integer type, Boolean cross, String desc) {
        this.type = type;
        this.cross = cross;
        this.desc = desc;
    }

    private Integer type;
    private Boolean cross;
    private String desc;

    public Integer getType() {
        return type;
    }

    public Boolean getCross() {
        return cross;
    }

    public String getDesc() {
        return desc;
    }

    public static DuibaLiveSupplierGoodsCrossEnums fromValue(int type) {
        for (DuibaLiveSupplierGoodsCrossEnums it : DuibaLiveSupplierGoodsCrossEnums.values()) {
            if (type == it.getType()) {
                return it;
            }
        }
        return NORMAL_GOODS;
    }
}
