package cn.com.duiba.live.supplier.center.api.tool.sku;

import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierGoodsSkuDto;
import cn.com.duiba.live.supplier.center.api.dto.sku.GoodsSkuInfo;
import cn.com.duiba.live.supplier.center.api.dto.sku.SkuAttributeNode;
import cn.com.duiba.live.supplier.center.api.tool.UnitUtils;

/**
 * @author xuwei
 * @description Sku解析器
 * @date 2018/11/12
 */
public class GoodsSkuResolver extends AbstractSkuResolver<DuibaLiveSupplierGoodsSkuDto, GoodsSkuInfo> {

    @Override
    protected DuibaLiveSupplierGoodsSkuDto toDto(Long appItemId, Long itemId, String attributeJson, GoodsSkuInfo goodsSkuInfo) {
        DuibaLiveSupplierGoodsSkuDto itemSku = new DuibaLiveSupplierGoodsSkuDto();
        itemSku.setSupplierGoodsId(itemId);
        itemSku.setAttributeJson(attributeJson);
        itemSku.setId(parseString2Long(goodsSkuInfo.getId()));
        itemSku.setFacePrice(UnitUtils.transformYuan2Fen(goodsSkuInfo.getFacePrice()));
        itemSku.setSalePrice(UnitUtils.transformYuan2Fen(goodsSkuInfo.getSalePrice()));
        itemSku.setCostPrice(UnitUtils.transformYuan2Fen(goodsSkuInfo.getCostPrice()));
        itemSku.setSuggestMarketPrice(UnitUtils.transformYuan2Fen(goodsSkuInfo.getSuggestMarketPrice()));
        itemSku.setMerchantCoding(goodsSkuInfo.getMerchantCoding());
        itemSku.setRemaining(goodsSkuInfo.getRemaining());
        itemSku.setPreRemaining(goodsSkuInfo.getPreRemaining());
        itemSku.setImgUrl(goodsSkuInfo.getImgUrl());
        itemSku.setStockId(parseString2Long(goodsSkuInfo.getStockId()));
        itemSku.setCardLibraryId(parseString2Long(goodsSkuInfo.getCardLibraryId()));
        return itemSku;
    }

    @Override
    protected String getAttributeJson(DuibaLiveSupplierGoodsSkuDto sku) {
        return sku.getAttributeJson();
    }

    @Override
    protected GoodsSkuInfo toVo(DuibaLiveSupplierGoodsSkuDto sku) {
        GoodsSkuInfo goodsSkuInfo = new GoodsSkuInfo();
        goodsSkuInfo.setId(parseLong2String(sku.getId()));
        goodsSkuInfo.setFacePrice(UnitUtils.transformFen2Yuan(sku.getFacePrice()));
        goodsSkuInfo.setSalePrice(UnitUtils.transformFen2Yuan(sku.getSalePrice()));
        goodsSkuInfo.setCostPrice(UnitUtils.transformFen2Yuan(sku.getCostPrice()));
        goodsSkuInfo.setSuggestMarketPrice(UnitUtils.transformFen2Yuan(sku.getSuggestMarketPrice()));
        goodsSkuInfo.setMerchantCoding(sku.getMerchantCoding());
        goodsSkuInfo.setImgUrl(sku.getImgUrl());
        goodsSkuInfo.setRemaining(sku.getRemaining());
        goodsSkuInfo.setPreRemaining(sku.getRemaining());
        goodsSkuInfo.setStockId(parseLong2String(sku.getStockId()));
        goodsSkuInfo.setCardLibraryId(parseLong2String(sku.getCardLibraryId()));
        return goodsSkuInfo;
    }

    @Override
    protected GoodsSkuInfo getSkuInfo(SkuAttributeNode<GoodsSkuInfo> node) {
        GoodsSkuInfo goodsSkuInfo = super.getSkuInfo(node);
        goodsSkuInfo.setImgUrl(node.getImgUrl());
        return goodsSkuInfo;
    }

    @Override
    protected void postNode(SkuAttributeNode<GoodsSkuInfo> headNode, SkuAttributeNode<GoodsSkuInfo> node) {
        //目前只有跟节点存储图片信息，从叶节点sku中获取图片
        if (node.getSkuInfo() != null) {
            if (headNode.getImgUrl() == null) {
                headNode.setImgUrl(node.getSkuInfo().getImgUrl());
            }
            //sku中图片信息清空，减少数据传输
            node.getSkuInfo().setImgUrl(null);
        }
    }
}
