package cn.com.duiba.live.supplier.center.api.base;

import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 分页响应实体
 * @param <T>
 */
public class PageResp<T> implements Serializable {

    private static final long serialVersionUID = -8562552778876270029L;

    /**
     * 总记录数
     */
    private int total;

    /**
     * 当前页记录
     */
    private List<T> list;

    public PageResp() {
    }

    public PageResp(int total, List<T> list) {
        this.total = total;
        this.list = list;
    }

    public PageResp(PageResp<?> pageResponse, List<T> list) {
        BeanUtils.copyProperties(pageResponse, this, "list");
        this.list = list;
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}
