package cn.com.duiba.live.supplier.center.api.dto;

import cn.com.duiba.live.supplier.center.api.enums.DuibaLiveSupplierGoodsAuditStateEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 供应商商品审核
 * @author fss
 */
public class DuibaLiveSupplierGoodsAuditDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 兑吧商品ID
     */
    private Long duibaItemId;

    /**
     * 供应商商品ID
     */
    private Long supplierGoodsId;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 商品类型
     */
    private String goodsType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品类目
     */
    private Long itemClassifyId;

    /**
     * 额外字段信息
     */
    private String extJson;

    /**
     * 审核详情/备注信息
     */
    private String remarkInfo;

    /**
     * 审核状态:0待审核,1审核通过,2审核拒绝,3取消申请
     * @see DuibaLiveSupplierGoodsAuditStateEnum
     */
    private Integer auditState;

    /**
     * 是否上架:0下架,1上架
     */
    private Integer enableState;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 提交审核时间
     */
    private Date submitTime;

    /**
     * 审核类型:1兑吧审核,2供应商审核
     */
    private Integer auditType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDuibaItemId() {
        return duibaItemId;
    }

    public void setDuibaItemId(Long duibaItemId) {
        this.duibaItemId = duibaItemId;
    }

    public Long getSupplierGoodsId() {
        return supplierGoodsId;
    }

    public void setSupplierGoodsId(Long supplierGoodsId) {
        this.supplierGoodsId = supplierGoodsId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(String goodsType) {
        this.goodsType = goodsType;
    }

    public String getExtJson() {
        return extJson;
    }

    public void setExtJson(String extJson) {
        this.extJson = extJson;
    }

    public String getRemarkInfo() {
        return remarkInfo;
    }

    public void setRemarkInfo(String remarkInfo) {
        this.remarkInfo = remarkInfo;
    }

    public Integer getAuditState() {
        return auditState;
    }

    public void setAuditState(Integer auditState) {
        this.auditState = auditState;
    }

    public Integer getEnableState() {
        return enableState;
    }

    public void setEnableState(Integer enableState) {
        this.enableState = enableState;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getSubmitTime() {
        return submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public Integer getAuditType() {
        return auditType;
    }

    public void setAuditType(Integer auditType) {
        this.auditType = auditType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Long getItemClassifyId() {
        return itemClassifyId;
    }

    public void setItemClassifyId(Long itemClassifyId) {
        this.itemClassifyId = itemClassifyId;
    }
}