package cn.com.duiba.live.supplier.center.api.dto.goods.sync;

import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierGoodsSkuDto;
import cn.com.duiba.live.supplier.center.api.dto.addr.AddrLimitSimpleDto;
import cn.com.duiba.live.supplier.center.api.enums.addr.AddrAreaLimitSwitch;
import cn.com.duiba.live.supplier.center.api.enums.addr.AddrLimitTypeEnum;
import cn.com.duiba.live.supplier.center.api.enums.goods.DuibaLiveGoodsType;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/01/11 19:36
 * @description 商品 - 基础信息Dto
 */
@Data
public class SupplierGoodsBaseDto implements Serializable {

    // ------- 商品属性  -------

    /**
     * 商品Id
     */
    private Long id;

    /**
     * 兑吧商品ID
     */
    private Long duibaItemId;

    /**
     * 商品类型
     * object-实物 card-卡券
     * {@link DuibaLiveGoodsType}
     */
    private String type;

    // ------- 商品信息  -------

    /**
     * 商品名称
     */
    private String name;

    /**
     * 商品备注
     */
    private String memo;

    /**
     * 商品缩略图
     */
    private String smallImage;

    /**
     * 商品详情图（主图）
     */
    private String multiImage;

    /**
     * logo
     */
    private String logo;

    /**
     * 商品分享图标
     */
    private String shareImage;

    /**
     * 运费价格
     */
    private Long expressPrice;

    // ------- 库存规格  -------

    /**
     * 是否多规格
     */
    private Boolean multiSku;

    /**
     * 商品sku规格属性
     */
    private List<DuibaLiveSupplierGoodsSkuDto> attributes;

    // ------- 购买限制  -------

    /**
     * 区域限制开关 on-开启 off-关闭
     * {@link AddrAreaLimitSwitch}
     */
    private String areaLimitSwitch;

    /**
     * 区域限制类型
     * {@link AddrLimitTypeEnum}
     */
    private Integer areaLimitType;

    /**
     * 区域限制地区
     */
    private List<AddrLimitSimpleDto> areaLimitAreas;

    // ------- 图文详情  -------

    /**
     * 详细说明
     */
    private String description;

    /**
     * 待发货文案
     */
    private String alertMessage;

    /**
     * 卖点描述
     */
    private String sellPoint;

    /**
     * 使用规则
     */
    private String usageRule;


}
