package cn.com.duiba.live.supplier.center.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.supplier.center.api.dto.DuibaLiveSupplierGoodsDto;
import cn.com.duiba.live.supplier.center.api.params.goods.DuibaLiveSupplierGoodsExportQueryParam;
import cn.com.duiba.live.supplier.center.api.params.goods.DuibaLiveSupplierGoodsQueryParam;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/01/10 14:03
 * @description 商品相关 RPC
 */
@AdvancedFeignClient
public interface RemoteDuibaLiveGoodsService {

    /**
     * 新增商品
     *
     * @param goodsDto 商品详情
     * @return 商品Id
     */
    Long insert(DuibaLiveSupplierGoodsDto goodsDto);

    /**
     * 更新商品
     *
     * @param goodsDto 商品详情
     * @return 更新结果
     */
    int update(DuibaLiveSupplierGoodsDto goodsDto);

    /**
     * 分页查询列表
     *
     * @param param 查询参数
     * @return 测试列表
     */
    List<DuibaLiveSupplierGoodsDto> listByParam(DuibaLiveSupplierGoodsQueryParam param);

    /**
     * 根据起始Id查询列表, 一次查询100条
     *
     * @param param 查询参数
     * @return 商品列表
     */
    List<DuibaLiveSupplierGoodsDto> listByParamAndStartId(DuibaLiveSupplierGoodsExportQueryParam param);

    /**
     * 查询记录的总记录数
     *
     * @param param 查询参数
     * @return 总记录数
     */
    Long countByParam(DuibaLiveSupplierGoodsQueryParam param);

    /**
     * 根据主键查询商品
     *
     * @param id 主键Id
     * @return 商品详情
     */
    DuibaLiveSupplierGoodsDto findById(Long id);

    /**
     * 查询商品信息（包括库存、扩展信息）
     *
     * @param id 商品Id
     * @return 商品完整信息
     */
    DuibaLiveSupplierGoodsDto findCompleteById(Long id);

    /**
     * 删除商品（逻辑删除）
     *
     * @param id 商品Id
     * @return 执行结果
     */
    int deleteById(Long id);

    /**
     * 更新商品上下架状态
     *
     * @param id          商品Id
     * @param enableState 更新状态
     * @param expectState 原来状态
     *                    {@link cn.com.duiba.live.supplier.center.api.enums.goods.DuibaLiveGoodsUpType}
     * @return 更新结果
     */
    int updateEnableState(Long id, Integer enableState, Integer expectState);
}
