/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.log.api.service;

import cn.com.duiba.log.api.appender.LogAppenderService;
import cn.com.duiba.log.api.context.LoggerThreadContext;
import cn.com.duiba.log.api.model.dto.LoggerMateInfoDTO;
import cn.com.duiba.log.api.model.param.LogParam;
import cn.com.duiba.log.api.util.SystemInfoUtil;
import cn.com.duiba.log.api.util.TemplateUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LoggerRunnable.class);
    private LoggerThreadContext threadContext;
    private LoggerMateInfoDTO mateInfo;
    private List<LogAppenderService> appenderServiceList;

    @Override
    public void run() {
        List<JSONObject> paramsList = this.threadContext.getParams();
        for (JSONObject json : paramsList) {
            try {
                String logContext = TemplateUtil.replaceArgs(this.threadContext.getTemplate(), json);
                LogParam param = new LogParam();
                param.setAppId(SystemInfoUtil.getThisSystemInfo().getId());
                param.setServerName(SystemInfoUtil.getThisSystemInfo().getAppName());
                param.setGroup(this.threadContext.getGroup());
                param.setUrl(this.mateInfo.getUrl());
                param.setUri(this.mateInfo.getUri());
                param.setIp(this.mateInfo.getIp());
                param.setActionTime(new Date());
                param.setTraceId(this.threadContext.getTraceId());
                param.setRoleCode(this.mateInfo.getRoleCode());
                param.setOperatorId(this.mateInfo.getOperatorId());
                param.setRequest(this.threadContext.getRequest());
                param.setResponse(this.threadContext.getResponse());
                param.setParams(json.toJSONString());
                param.setLogContent(logContext);
                for (LogAppenderService appender : this.appenderServiceList) {
                    try {
                        LogParam clone = new LogParam();
                        BeanUtils.copy((Object)param, (Object)clone);
                        appender.acceptOperationLog(clone);
                    }
                    catch (Exception e) {
                        log.error("Class[{}]\u5904\u7406\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25", (Object)appender.getClass().getSimpleName(), (Object)e);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u64cd\u4f5c\u65e5\u5fd7\u53d1\u9001\u5931\u8d25");
            }
        }
    }

    public LoggerThreadContext getThreadContext() {
        return this.threadContext;
    }

    public LoggerMateInfoDTO getMateInfo() {
        return this.mateInfo;
    }

    public List<LogAppenderService> getAppenderServiceList() {
        return this.appenderServiceList;
    }

    public void setThreadContext(LoggerThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public void setMateInfo(LoggerMateInfoDTO mateInfo) {
        this.mateInfo = mateInfo;
    }

    public void setAppenderServiceList(List<LogAppenderService> appenderServiceList) {
        this.appenderServiceList = appenderServiceList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoggerRunnable)) {
            return false;
        }
        LoggerRunnable other = (LoggerRunnable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoggerThreadContext this$threadContext = this.getThreadContext();
        LoggerThreadContext other$threadContext = other.getThreadContext();
        if (this$threadContext == null ? other$threadContext != null : !((Object)this$threadContext).equals(other$threadContext)) {
            return false;
        }
        LoggerMateInfoDTO this$mateInfo = this.getMateInfo();
        LoggerMateInfoDTO other$mateInfo = other.getMateInfo();
        if (this$mateInfo == null ? other$mateInfo != null : !((Object)this$mateInfo).equals(other$mateInfo)) {
            return false;
        }
        List<LogAppenderService> this$appenderServiceList = this.getAppenderServiceList();
        List<LogAppenderService> other$appenderServiceList = other.getAppenderServiceList();
        return !(this$appenderServiceList == null ? other$appenderServiceList != null : !((Object)this$appenderServiceList).equals(other$appenderServiceList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoggerRunnable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoggerThreadContext $threadContext = this.getThreadContext();
        result = result * 59 + ($threadContext == null ? 43 : ((Object)$threadContext).hashCode());
        LoggerMateInfoDTO $mateInfo = this.getMateInfo();
        result = result * 59 + ($mateInfo == null ? 43 : ((Object)$mateInfo).hashCode());
        List<LogAppenderService> $appenderServiceList = this.getAppenderServiceList();
        result = result * 59 + ($appenderServiceList == null ? 43 : ((Object)$appenderServiceList).hashCode());
        return result;
    }

    public String toString() {
        return "LoggerRunnable(threadContext=" + this.getThreadContext() + ", mateInfo=" + this.getMateInfo() + ", appenderServiceList=" + this.getAppenderServiceList() + ")";
    }
}

