/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.log.api.util;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPoolUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonPoolUtil.class);
    private static ThreadPoolExecutor localLogThreadPool;

    private CommonPoolUtil() {
    }

    public static ThreadPoolExecutor getLocalLogThreadPool() {
        return localLogThreadPool;
    }

    static {
        MyFactory logThreadFactory = new MyFactory("log");
        MyIgnorePolicy handler = new MyIgnorePolicy();
        localLogThreadPool = new ThreadPoolExecutor(5, 20, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(2000), logThreadFactory, handler);
        localLogThreadPool.prestartAllCoreThreads();
    }

    public static class MyIgnorePolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            this.doLog(r);
        }

        private void doLog(Runnable r) {
            log.error(r.toString() + " rejected");
        }
    }

    public static class MyFactory
    implements ThreadFactory {
        private final AtomicInteger mThreadNum = new AtomicInteger(1);
        private String threadName;

        public MyFactory() {
        }

        public MyFactory(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.threadName + "-thread-" + this.mThreadNum.getAndIncrement());
            log.info(t.getName() + " has been created");
            return t;
        }
    }
}

