/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.log.api.aop;

import cn.com.duiba.log.api.annotation.LoggerMethod;
import cn.com.duiba.log.api.context.LoggerThreadContext;
import cn.com.duiba.log.api.exception.LogRunTimeException;
import cn.com.duiba.log.api.service.MyLogger;
import cn.com.duiba.log.api.util.BraveTraceUtil;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LoggerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggerInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(cn.com.duiba.log.api.annotation.LoggerMethod)")
    public Object logger(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        try {
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            Method method = methodSignature.getMethod();
            LoggerMethod loggerMethod = (LoggerMethod)AnnotationUtils.findAnnotation((Method)method, LoggerMethod.class);
            String template = Objects.requireNonNull(loggerMethod).value();
            String group = loggerMethod.group();
            String request = JSON.toJSONString((Object)point.getArgs());
            if (StringUtils.isBlank((String)template)) {
                throw new LogRunTimeException("\u64cd\u4f5c\u65e5\u5fd7: " + group + ", template\u4e0d\u80fd\u4e3a\u7a7a");
            }
            LoggerThreadContext context = new LoggerThreadContext();
            context.setTemplate(template);
            context.setGroup(group);
            context.setRequest(request);
            context.setTraceId(BraveTraceUtil.getTracerId());
            MyLogger.setLoggerThreadContext(context);
            result = point.proceed();
            MyLogger.setResponse(JSON.toJSONString((Object)result));
        }
        catch (LogRunTimeException e) {
            throw new LogRunTimeException(e.getMessage());
        }
        catch (Exception e) {
            log.error("Aspect Exception methodName:{} params:{}", new Object[]{point.getSignature().getName(), JSON.toJSONString((Object)point.getArgs()), e});
        }
        finally {
            MyLogger.flush();
        }
        return result;
    }
}

