/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.log.api.context;

import cn.com.duiba.log.api.exception.LogRunTimeException;
import cn.com.duiba.log.api.model.param.RequestParam;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContext {
    private static final Logger log = LoggerFactory.getLogger(RequestContext.class);
    private static final ThreadLocal<RequestParam> threadRequestParam = new ThreadLocal();

    public static void setRequestInThreadLocal(HttpServletRequest request) {
        if (Objects.isNull(request)) {
            throw new LogRunTimeException("\u89e3\u6790request\u4e3a\u7a7a");
        }
        RequestParam requestParam = new RequestParam();
        requestParam.setIp(RequestTool.getIpAddr((HttpServletRequest)request));
        requestParam.setUrl(RequestTool.getRequestUrl((HttpServletRequest)request));
        requestParam.setUri(request.getRequestURI());
        threadRequestParam.set(requestParam);
    }

    public static void removeRequestInThreadLocal() {
        threadRequestParam.remove();
    }

    public static RequestParam getRequestParam() {
        RequestParam requestParam = threadRequestParam.get();
        if (Objects.isNull(requestParam)) {
            throw new LogRunTimeException("\u83b7\u53d6\u6e90\u6570\u636e\u5931\u8d25");
        }
        return requestParam;
    }
}

