/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.log.api.mq.config;

import cn.com.duiba.log.api.mq.config.LogRocketMqProperties;
import cn.com.duiba.log.api.mq.producer.MqLogMessageProducer;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.DefaultMQProducerWrapper;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DefaultMQProducer.class})
@EnableConfigurationProperties(value={LogRocketMqProperties.class})
public class LogMqProducerConfigurator
implements InitializingBean {
    @Autowired
    protected LogRocketMqProperties logRocketMqProperties;

    public void afterPropertiesSet() throws Exception {
        DefaultMQProducerWrapper p = new DefaultMQProducerWrapper();
        p.setProducerGroup(this.logRocketMqProperties.getProducer().getGroup());
        p.setNamesrvAddr(this.logRocketMqProperties.getNameSrvAddr());
        p.setSendMsgTimeout(this.logRocketMqProperties.getProducer().getSendMsgTimeoutMillis().intValue());
        p.start();
        MqLogMessageProducer.setDefaultMQProducer((DefaultMQProducer)p);
    }
}

