/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.log.api.mq.producer;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MqLogMessageProducer {
    private static final Logger log = LoggerFactory.getLogger(MqLogMessageProducer.class);
    private static DefaultMQProducer defaultMQProducer;

    public static void setDefaultMQProducer(DefaultMQProducer defaultMQProducer) {
        MqLogMessageProducer.defaultMQProducer = defaultMQProducer;
    }

    public void send(Object dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        String body = dto instanceof String ? (String)dto : JSON.toJSONString((Object)dto);
        try {
            Message message = new Message("duiba_log_topic", "duiba_log_tag", body.getBytes(StandardCharsets.UTF_8));
            SendResult send = defaultMQProducer.send(message);
            if (Objects.isNull(send) || !SendStatus.SEND_OK.equals((Object)send.getSendStatus())) {
                log.error("send mq error, send={}, body={}", (Object)JSON.toJSONString((Object)send), (Object)body);
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

