/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.log.api.service;

import cn.com.duiba.log.api.appender.LogAppenderService;
import cn.com.duiba.log.api.context.LoggerStackContext;
import cn.com.duiba.log.api.context.LoggerThreadContext;
import cn.com.duiba.log.api.service.LoggerMateInfoAdapter;
import cn.com.duiba.log.api.service.LoggerRunnable;
import cn.com.duiba.log.api.service.MyLogger;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoggerService
implements InitializingBean {
    private final ThreadLocal<LoggerStackContext> threadContext = new ThreadLocal();
    @Resource(name="logExecutorService")
    private ExecutorService logExecutorService;
    @Autowired
    private List<LogAppenderService> logAppenderServices;
    @Autowired(required=false)
    private LoggerMateInfoAdapter loggerMateInfoAdapter;

    public void afterPropertiesSet() {
        MyLogger.setLoggerService(this);
    }

    public LoggerStackContext initStackContext() {
        LoggerStackContext context = this.threadContext.get();
        if (Objects.isNull(context)) {
            context = new LoggerStackContext();
            this.threadContext.set(context);
        }
        return context;
    }

    public void setThreadContext(LoggerThreadContext context) {
        LoggerStackContext stackContext = this.initStackContext();
        if (Objects.isNull(stackContext)) {
            return;
        }
        stackContext.addContext(context);
    }

    public void log(JSONObject json) {
        Objects.requireNonNull(json);
        LoggerStackContext context = this.threadContext.get();
        if (Objects.isNull(context)) {
            return;
        }
        context.addLogParam(json);
    }

    public void addResponse(String response) {
        Objects.requireNonNull(response);
        LoggerStackContext context = this.threadContext.get();
        if (Objects.isNull(context)) {
            return;
        }
        context.addResponse(response);
    }

    public void addOperator(String operator) {
        Objects.requireNonNull(operator);
        LoggerStackContext context = this.threadContext.get();
        if (Objects.isNull(context)) {
            return;
        }
        context.addOperator(operator);
    }

    public void flushThreadContext() {
        LoggerStackContext stackContext = this.threadContext.get();
        if (Objects.isNull(stackContext)) {
            return;
        }
        LoggerThreadContext context = stackContext.popContext();
        LoggerRunnable runnable = new LoggerRunnable();
        runnable.setThreadContext(context);
        runnable.setAppenderServiceList(this.logAppenderServices);
        runnable.setMateInfo(this.loggerMateInfoAdapter.getLoggerMateInfo());
        this.logExecutorService.submit(runnable);
        if (stackContext.isEmpty().booleanValue()) {
            this.threadContext.remove();
        }
    }
}

