package cn.com.duiba.log.api.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

import java.util.Objects;

/**
 * 功能描述：日志记录方式
 * recordType： 1：mq 2：rpc
 *
 * @Auther: xiaotian
 * @Date: 2021/11/9 10:49
 * @Description:
 */
@ConfigurationProperties(prefix = "log.data.record.config")
@Configuration
@RefreshScope
public class LogRecordSourceConfig {

    private Integer recordType = 1;


    public boolean mq() {
        return Objects.equals(1, recordType);
    }

    public Integer getRecordType() {
        return recordType;
    }

    public void setRecordType(Integer recordType) {
        this.recordType = recordType;
    }
}
