package cn.com.duiba.log.api.context;

import cn.com.duiba.log.api.constant.Constant;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @Description 线程存储日志
 * @Author dangcang
 * @Date 2021/11/4 11:28 上午
 **/
@Slf4j
@Data
public class LoggerThreadContext {

    private String template;

    /**
     * 模块名称
     */
    private String group;

    /**
     * 提交日志的链路id
     */
    private String traceId;

    /**
     * 请求参数
     */
    private String request;

    /**
     * 返回参数
     */
    private String response;

    private final List<JSONObject> params = Lists.newArrayList();

    public void addParam(JSONObject param) {
        if (params.size() > Constant.MAX_LOG_NUM) {
            log.warn("单线程操作日志提交量超过上限:" + Constant.MAX_LOG_NUM);
            return;
        }
        this.params.add(param);
    }

}