package cn.com.duiba.log.api.mq.producer;

import cn.com.duiba.log.api.config.LogMqConfig;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.message.Message;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

/**
 * @author xiaotian
 * @description 日志mq发送
 * @date 2021-11-09 10:36
 */
@Component
@Slf4j
public class MqLogMessageProducer {

    @Resource(name = "logRocketMqProducer")
    private DefaultMQProducer defaultMQProducer;

    public void send(Object dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        String body;
        if (dto instanceof String) {
            body = (String) dto;
        } else {
            body = JSON.toJSONString(dto);
        }
        try {
            Message message = new Message(LogMqConfig.logTopic, LogMqConfig.logTag, body.getBytes(StandardCharsets.UTF_8));
            SendResult send = defaultMQProducer.send(message);
            if (Objects.isNull(send) || !SendStatus.SEND_OK.equals(send.getSendStatus())) {
                log.error("send mq error, send={}, body={}", JSON.toJSONString(send), body);
            }
        } catch (Exception e) {
            log.error("发送消息失败：", e);
        }
    }
}
