package cn.com.duiba.log.api.service;

import cn.com.duiba.log.api.context.LoggerThreadContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;
import java.util.Objects;

/**
 * @Description 日志发送，转化类
 * @Author dangcang
 * @Date 2021/11/4 10:17 上午
 **/
public class MyLogger {

    private static volatile LoggerService loggerService;

    /**
     * 初始化后注入 loggerService
     * @param loggerService
     */
    public static void setLoggerService(LoggerService loggerService) {
        MyLogger.loggerService = loggerService;
    }

    /**
     * 根据简单打印日志,简单类将被JSON序列化
     * @param params
     */
    public static void logForPojo(Object params) {
        Objects.requireNonNull(params);
        JSONObject json = new JSONObject();
        if (params instanceof Map) {
            json.putAll((Map) params);
        } else {
            String jsonStr = JSONObject.toJSONString(params);
            json.putAll(JSON.parseObject(jsonStr));
        }
        logForJson(json);
    }

    /**
     * 通过json渲染日志
     * @param json
     */
    public static void logForJson(JSONObject json) {
        Objects.requireNonNull(json);

        loggerService.log(json);
    }

    /**
     * 请求线程前置调用
     * @param context
     */
    public static void setLoggerThreadContext(LoggerThreadContext context) {
        loggerService.setThreadContext(context);
    }

    /**
     * 请求线程后置调用
     */
    public static void flush() {
        loggerService.flushThreadContext();
    }

}