package cn.com.duiba.cloud.order.center.api.model.param.batchtask;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 请描述类的业务用途
 * @Author dangcang
 * @Date 2021/11/11 11:27 上午
 **/
@Data
public class BatchTaskQueryParam extends PageRequest implements Serializable {

    private static final long serialVersionUID = -248222680639660802L;
    /**
     * 批量任务id
     */
    private Long batchTaskId;

    /**
     * 操作人id
     */
    private Long operatorId;

    /**
     * 任务类型
     * @see cn.com.duiba.cloud.order.center.api.enums.BatchTypeEnum
     */
    private Integer batchTaskType;

    /**
     * 开始时间 毫秒级时间戳
     */
    private Long startTime;

    /**
     * 截止时间 毫秒级时间戳
     */
    private Long endTime;

}